/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.block;

import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.world.World;

public class BlockSpike
extends Block {
    public BlockSpike(String tag, int tex) {
        super(tag, tex);
    }

    @Override
    public void render(Tesselator tess, World level, int layer, int x, int y, int z) {
        if (!(level.isLit(x, y, z) ^ layer == 1)) {
            return;
        }
        int tex = this.getTexture(0);
        float u0 = (float)(tex % 16) / 16.0f;
        float u1 = u0 + 0.0624375f;
        float v0 = (float)(tex / 16) / 16.0f;
        float v1 = v0 + 0.0624375f;
        float baseSize = 0.375f;
        float height = 1.0f;
        float x0 = (float)x + 0.5f - baseSize;
        float x1 = (float)x + 0.5f + baseSize;
        float xCenter = (float)x + 0.5f;
        float y0 = y;
        float y1 = (float)y + height;
        float z0 = (float)z + 0.5f - baseSize;
        float z1 = (float)z + 0.5f + baseSize;
        float zCenter = (float)z + 0.5f;
        if (!level.isSolidBlock(x, y - 1, z)) {
            tess.setColor(1.0f, 1.0f, 1.0f);
            tess.addVertexWithUV(x0, y0, z1, u0, v1);
            tess.addVertexWithUV(x0, y0, z0, u0, v0);
            tess.addVertexWithUV(x1, y0, z0, u1, v0);
            tess.addVertexWithUV(x1, y0, z1, u1, v1);
        }
        tess.setColor(0.8f, 0.8f, 0.8f);
        tess.addVertexWithUV(x0, y0, z0, u0, v1);
        tess.addVertexWithUV(xCenter, y1, zCenter, (u0 + u1) / 2.0f, v0);
        tess.addVertexWithUV(x1, y0, z0, u1, v1);
        tess.addVertexWithUV(x1, y0, z0, u1, v1);
        tess.setColor(0.8f, 0.8f, 0.8f);
        tess.addVertexWithUV(x1, y0, z1, u1, v1);
        tess.addVertexWithUV(xCenter, y1, zCenter, (u0 + u1) / 2.0f, v0);
        tess.addVertexWithUV(x0, y0, z1, u0, v1);
        tess.addVertexWithUV(x0, y0, z1, u0, v1);
        tess.setColor(0.6f, 0.6f, 0.6f);
        tess.addVertexWithUV(x0, y0, z1, u0, v1);
        tess.addVertexWithUV(xCenter, y1, zCenter, (u0 + u1) / 2.0f, v0);
        tess.addVertexWithUV(x0, y0, z0, u1, v1);
        tess.addVertexWithUV(x0, y0, z0, u1, v1);
        tess.setColor(0.6f, 0.6f, 0.6f);
        tess.addVertexWithUV(x1, y0, z0, u0, v1);
        tess.addVertexWithUV(xCenter, y1, zCenter, (u0 + u1) / 2.0f, v0);
        tess.addVertexWithUV(x1, y0, z1, u1, v1);
        tess.addVertexWithUV(x1, y0, z1, u1, v1);
    }

    @Override
    public boolean shouldCullFace(int face) {
        return face == 0;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean blocksLight() {
        return false;
    }

    @Override
    public boolean hasCustomModel() {
        return true;
    }
}

